#include "Button.h"
#include "Application.h"



Button::Button( int X, int Y, int W, int H, 
                const std::string& ImageNormal,
                const std::string& ImageMouseOver,
                const std::string& ImagePushed,
                int ButtonID ) :
  m_MouseOver( false ),
  m_Pushed( false ),
  m_ID( ButtonID ),
  m_X( X ),
  m_Y( Y ),
  m_W( W ),
  m_H( H ),
  m_Color( 0xff880000 )
{

  m_SectionNormal     = ImageNormal;
  m_SectionMouseOver  = ImageMouseOver;
  m_SectionPushed     = ImagePushed;

}



Button::Button( int X, int Y, int W, int H, 
                const std::string& ImageNormal,
                const std::string& ImageMouseOver,
                const std::string& ImagePushed,
                const std::string& TextArg,
                int ButtonID ) :
  m_MouseOver( false ),
  m_Pushed( false ),
  m_ID( ButtonID ),
  m_Text( TextArg ),
  m_X( X ),
  m_Y( Y ),
  m_W( W ),
  m_H( H ),
  m_Color( 0xff880000 )
{

  m_SectionNormal     = ImageNormal;
  m_SectionMouseOver  = ImageMouseOver;
  m_SectionPushed     = ImagePushed;

}



Button::~Button()
{

}



bool Button::UpdateMouse( int Buttons, int X, int Y )
{

  if ( ( X >= m_X )
  &&   ( X < m_X + m_W )
  &&   ( Y >= m_Y )
  &&   ( Y < m_Y + m_H ) )
  {
    if ( !m_MouseOver )
    {
      m_MouseOver = true;
      g_App.PlaySound( "RollOver" );
      m_Color = 0xffffd0d0;
    }
    if ( Buttons & 1 )
    {
      if ( !m_Pushed )
      {
        m_Pushed = true;
        g_App.PlaySound( "Click" );
      }
    }
    else
    {
      if ( m_Pushed )
      {
        m_Pushed = false;
        return true;
      }
    }
  }
  else
  {
    if ( m_MouseOver )
    {
      m_MouseOver = false;
      if ( m_Pushed )
      {
        m_Pushed    = false;
      }
      m_Color = 0xff800000;
    }
  }

  return false;

}



void Button::Render()
{

  if ( m_Pushed )
  {
    g_App.RenderTextureSection( m_SectionPushed, m_X, m_Y );
  }
  else if ( m_MouseOver )
  {
    g_App.RenderTextureSection( m_SectionMouseOver, m_X, m_Y );
  }
  else
  {
    g_App.RenderTextureSection( m_SectionNormal, m_X, m_Y );
  }

  if ( m_Pushed )
  {
    g_App.RenderTextCentered( "GUI.Small", m_Text, m_X + m_W / 2, m_Y + m_H / 2 - 11, m_Color );
  }
  else
  {
    g_App.RenderTextCentered( "GUI.Small", m_Text, m_X + m_W / 2, m_Y + m_H / 2 - 11, m_Color );
  }

}